<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_make_donation_form")){
	class wecare_make_donation_form{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_make_donation_form_init"));
			add_shortcode('wecare_make_donation_form',array($this,'wecare_make_donation_form_shortcode'));
		}
		function wecare_make_donation_form_init(){

			if(function_exists("vc_map")){
				
				vc_map( array(
					"base" => "wecare_make_donation_form",
					"name" => __( "Make Donation ", "js_composer" ),
					"class" => "wecare_make_donation_form_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_make_donation_form_icon",
					"params" => array(
					
		
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Enter Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Enter Caption", "js_composer" ),
								"param_name" => "element_caption",
								"description" => __( "Enter Element Caption Here", "js_composer" )
							),

							array(
								"type" => "textarea_html",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Contact Form 7", "js_composer" ),
								"param_name" => "content",
								"description" => __( "Enter Contact Form 7 Shortcode Here", "js_composer" )
							),
							
						)
					) 
				);
			}
		}
		
		
		function wecare_make_donation_form_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
				
				'element_title' => '',
				'element_caption' => '',
	
			), $atts );
				
			
			extract( $result );


			$output = '
			
				<section class="donation-row paypal-exte">
				  <div class="element_wrap">
					<div class="row">
					  <div class="col-md-12">
						<div class="donation-box">
						  <div class="heading-style-1"> 
							<span>'.$element_title.'</span>
							<h2>'.$element_caption.'</h2>
						  </div>
						  '.do_shortcode($content).'
						</div>
					  </div>
					</div>
				  </div>
				</section>';

			return $output;
			

		} /* end of function */
		
		
	}
	
	new wecare_make_donation_form;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_make_donation_form extends WPBakeryShortCode {
		}
	}
}