<?php
/**
 * Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2023 All Rights Reserved
 *
 * Licensed under CLOUD LINUX LICENSE AGREEMENT
 * http://cloudlinux.com/docs/LICENSE.TXT
 */

class Modules_AccelerateWp_ApiRpc extends pm_Hook_ApiRpc
{
    /**
     * @var array[]
     */
    private $commands = [
        'cloudlinux-awp-admin' => \Modules_AccelerateWp_ApiRpc\CloudlinuxAwpAdminCommand::class,
    ];

    /**
     * @param  array  $data
     *
     * @return array
     */
    public function call($data)
    {
        if ( ! pm_Session::getClient()->isAdmin()) {
            throw new pm_Exception('Permission denied', 401, null);
        }

        $result = [];

        foreach ($data as $command => $args) {
            if (array_key_exists($command, $this->commands)) {
                try {
                    $result[$command] = (new $this->commands[$command])->run($args);
                } catch (Exception $e) {
                    $result[$command] = [
                        'code'   => $e->getCode(),
                        'stdout' => '',
                        'stderr' => $e->getMessage(),
                    ];
                }
            } else {
                throw new pm_Exception('Route not found', 404, null);
            }
        }

        return $result;
    }
}
