<?php
/**
 * The template for displaying featured content
 *
 * @package CrunchPress
 * @subpackage WP Theme
 */
	/* getting values from backend */
	$wecare_num_excerpt = '';
	$wecare_default_settings = get_option('default_pages_settings');

	if($wecare_default_settings != ''){
		$wecare_default = new DOMDocument ();
		$wecare_default->loadXML ( $wecare_default_settings );
		$wecare_num_excerpt = wecare_find_xml_value($wecare_default->documentElement,'default_excerpt');
	}
	if($wecare_num_excerpt == '' || $wecare_num_excerpt == 0 ) {
		$wecare_num_excerpt = 250;
	}
?>
	<div class="main-content margin-top-bottom">
		<div class="single_content blog_listing">
			<div id="<?php the_ID(); ?>" class="blog_post_detail cp_sticky_post">
			<?php
			/*
			 * Fires before the WP featured content.
			 *
			 * @since WP 1.0
			 */
		
			$wecare_thumbnail_types = '';
			$wecare_featured_posts = wecare_get_featured_posts();
			foreach ( (array) $wecare_featured_posts as $order => $post ) :
				setup_postdata( $post ); 
				$wecare_thumbnail_types = '';
				$wecare_post_detail_xml = get_post_meta($post->ID, 'post_detail_xml', true);
				
				if($wecare_post_detail_xml <> ''){
					$wecare_post_xml = new DOMDocument ();
					$wecare_post_xml->loadXML ( $wecare_post_detail_xml );
					$wecare_post_social = wecare_find_xml_value($wecare_post_xml->documentElement,'post_social');
					$wecare_sidebar = wecare_find_xml_value($wecare_post_xml->documentElement,'sidebar_post');
					$wecare_right_sidebar = wecare_find_xml_value($wecare_post_xml->documentElement,'right_sidebar_post');
					$wecare_left_sidebar = wecare_find_xml_value($wecare_post_xml->documentElement,'left_sidebar_post');
					$wecare_thumbnail_types = wecare_find_xml_value($wecare_post_xml->documentElement,'post_thumbnail');
					$wecare_video_url_type = wecare_find_xml_value($wecare_post_xml->documentElement,'video_url_type');
					$wecare_select_slider_type = wecare_find_xml_value($wecare_post_xml->documentElement,'select_slider_type');	
				}
				
				$wecare_thumbnail_id = get_post_thumbnail_id( $post->ID );
				$wecare_image_thumb = wp_get_attachment_image_src($wecare_thumbnail_id, array(1170,600));
				$wecare_image_thumb = wp_get_attachment_image_src($wecare_thumbnail_id, 'full');
				$wecare_mask_html = '';
				$wecare_image_class = 'no-image';
				
				if(get_the_post_thumbnail($post->ID, array(1170,600)) <> ''){
					$wecare_mask_html = '<div class="mask">
						<a href="'.esc_url(get_permalink()).'#comments" class="anchor"><span> </span> <i class="fa fa-comment"></i></a>
						<a href="'.esc_url(get_permalink()).'" class="anchor"> <i class="fa fa-link"></i></a>
					</div>';
					$wecare_mask_html = 'image-exists';
				}			

				$wecare_get_post_cp = get_post($post); 
				/* Markup */
				?>
				
				<div <?php post_class(); ?>>
					<div class="post-box">
						<div class="frame"> 
							<?php echo get_the_post_thumbnail($post->ID, array(850,450)); ?>
						</div>
						<div class="text-box">
							<h3><a href="<?php echo esc_url(get_the_permalink());?>"><?php echo esc_attr(get_the_title());?></a></h3>
								<div class="tags-row"> 
									<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ));?>" class="link"><i class="fa fa-user" aria-hidden="true"></i><?php echo esc_attr(get_the_author());?></a> 
									<a href="<?php echo esc_url(get_the_permalink());?>" class="link"><i class="fa fa-calendar" aria-hidden="true"></i><?php echo esc_attr(get_the_date());?></a> 
									<a href="<?php echo esc_url(get_the_permalink());?>" class="link"><i class="fa fa-comments-o" aria-hidden="true"></i><?php echo esc_attr($comment_count);?></a> 
								</div>
								<div class = "index_content">
									<?php /* Content */
										the_content();
										wp_link_pages( array(
											'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'wecare' ) . '</span>',
											'after'       => '</div>',
											'link_before' => '<span>',
											'link_after'  => '</span>',
											'pagelink'    => '<span class="screen-reader-text"></span>%',
											'separator'   => '<span class="screen-reader-text"></span>',
										) );
									?>
								</div>
							<a href="<?php echo esc_url(get_the_permalink());?>" class="btn-readmore"><?php esc_html_e('Read Blog Detail','wecare');?></a>
						</div>  
					</div>
				</div>
				<?php
			endforeach;
			/**
			 * Fires after the featured content.
			 *
			 * @since WP
			 */

			wp_reset_postdata(); ?> 
			</div><!-- .featured-content-inner -->
		</div><!-- #featured-content .featured-content -->
	</div><!-- #featured-content .featured-content -->