<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_sponsors_gallery")){
	class wecare_sponsors_gallery{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_sponsors_gallery_init"));
			add_shortcode('wecare_sponsors_gallery',array($this,'wecare_sponsors_gallery_shortcode'));
		}
		function wecare_sponsors_gallery_init(){

			if(function_exists("vc_map")){
				
				vc_map( array(
					"base" => "wecare_sponsors_gallery",
					"name" => __( "Sponsors Gallery", "js_composer" ),
					"class" => "wecare_sponsors_gallery_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_sponsors_gallery_icon",
					"params" => array(
	
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Element Caption", "js_composer" ),
							"param_name" => "element_caption",
							"description" => __( "Enter Element Title Here", "js_composer" )
						),
					
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Element Title", "js_composer" ),
							"param_name" => "element_title",
							"description" => __( "Enter Element Title Here", "js_composer" )
						),
	
						array(
							'type' => 'attach_images',
							"holder" => "p",
							'heading' => __( 'Images', 'js_composer' ),
							'param_name' => 'images',
							'value' => '',
							'description' => __( 'Select Images From Media Library', 'js_composer' )
						),
			
					)
				) );
			}
		}
		
		
		function wecare_sponsors_gallery_shortcode( $atts, $content = null ) {
			
			$result = shortcode_atts( array(
				
				'element_title' => '',
				'element_caption' => '',
				'images' => '',

	
			), $atts );
			
			extract( $result );
			
		
			$ex_images = explode(',',$images);

			$output = '
			
			<section class="donors-supporters">
			  <div class="element_wrap">
				<div class="heading-style-1"> 
					<span>'.$element_caption.'</span>
					<h2>'.$element_title.'</h2>
				</div>
				<div id="supporters" class="owl-carousel">';
				  
					foreach($ex_images as $image_id){
								
						$image = wpb_getImageBySize( array( 'attach_id' => $image_id, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
						$feat_image =  $image['p_img_large'][0];
						$output .= '
						 <div class="item">
							<div class="donors-box"><a><img src="'.$feat_image.'" alt="'.esc_html__('sponsor-image','wecare').'"></a></div>
						</div>';
					}
					
					$output .= '
				</div>
			  </div>
			</section>';
							
						
			return $output;
			
		}
		
	}
	new wecare_sponsors_gallery;
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_sponsors_gallery extends WPBakeryShortCode {
		}
	}
}