<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_projects_filter")){
	class wecare_projects_filter{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_projects_filter_init"));
			add_shortcode('wecare_projects_filter',array($this,'wecare_projects_filter_shortcode'));
		}
		function wecare_projects_filter_init(){

			if(function_exists("vc_map")){
				
				 $args = array(
					'type'                     => 'projects',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'projects-categories',
					'pad_counts'               => false 
				);
				
				$categories = get_categories( $args ); 				
						
				
				$taxonomies = get_taxonomies();
				
				if($categories){
					$categoryArray[0] = "All";
					foreach($categories as $category_list){
						$categoryArray[$category_list->term_id] = $category_list->name;
					}
				} else {
					$categoryArray = array();
				}
				
				vc_map( array(
					"base" => "wecare_projects_filter",
					"name" => __( "Projects Filter", "js_composer" ),
					"class" => "wecare_projects_filter_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_projects_filter_news_full",
					"params" => array(
			
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Enter Caption", "js_composer" ),
							"param_name" => "element_caption",
							"description" => __( "Enter Caption Here, will appear above title", "js_composer" )
						),
						
						array(
							"type" => "textfield",
							"holder" => "p",
							"class" => "",
							"heading" => __( "Enter Title", "js_composer" ),
							"param_name" => "element_title",
							"description" => __( "Enter Element Title Here.", "js_composer" )
						),
						
						array(
							"type" => "dropdown",
							"holder" => "p",
							"heading" => __( "Categories", "js_composer" ),
							"param_name" => "category_name",
							"value" => $categoryArray,
							"description" => __( "Select Category From The Dropdown", "js_composer" )
						),
						
						array(
								'type' => 'vc_link',
								"holder" => "p",
								'heading' => __( 'View More (Link)', 'js_composer' ),
								'param_name' => 'readmore_url',
								'description' => __( 'Add Text & Link For Button.', 'js_composer' ),
						),
	
					)
				) );
			}
		}
		
		
		function wecare_projects_filter_shortcode( $atts, $content = null ) {
			
			$result = shortcode_atts( array(

				'element_caption' => '',
				'element_title' => '',
				'category_name' => '',
				'readmore_url' => '',

			), $atts );
			
			extract( $result );
			
			/* Build Link First */
			
			$readmore_url = vc_build_link( $readmore_url );

			if(!empty($readmore_url['url'])){ $readmore_url_link =  esc_url($readmore_url['url']); }else{ $readmore_url_link = ''; }

			if(!empty($readmore_url['title'])){ $readmore_text =  esc_attr($readmore_url['title']); }else{ $readmore_text = ''; }
			
			
			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($category_name != 'All' && !empty($category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $category_name, 'projects-categories');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'projects-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' => 'projects',
						'posts_per_page' => -1,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'projects-categories',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'title',
						'order' 			=> 'ASC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'projects',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> -1,
						'orderby'		 	=> 'title',
						'order' 			=> 'ASC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'projects',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> -1,
					'orderby'		 	=> 'title',
					'order' 			=> 'ASC'
				);
			
			}
			
			
			query_posts($args);
			
	
				/* Isotope Scripts */
				wp_enqueue_script( 'isotope-packaged', wecare_PATH_URL.'/frontend/js/jquery.isotope.js', false, '1.0', true);
				wp_enqueue_script( 'isotope-sorting', wecare_PATH_URL.'/frontend/js/sorting.js', false, '1.0', true);
				
				$output = '
						
				<section class="filter-gallery">
				  <div class="container">
					<div class="heading-style-1"> 
						<span>'.$element_caption.'</span>
						<h2>'.$element_title.'</h2>
					</div>';
					
						
						$output .= '
						
						<div id="options" class="col-md-12">
						  <ul id="filter" class="option-set" data-option-key="filter">';
						  
								$categories = get_categories( array('child_of' => $category_name, 'taxonomy' => 'projects-categories', 'hide_empty' => 0, 'orderby' => 'date', 'order' => 'DESC') );
								
								if(!empty($categories)){

									foreach($categories as $values){
									
										if (get_category($values)->category_count > 1){;
											
											
											$output .= '<li><a href="#filter" data-option-value=".'.esc_attr($values->term_id).'">'.esc_attr($values->name).'</a></li>';
										}                               
									}
								}
								$output .= '
								
						  </ul>
						</div>
						<div class="portfolio_block pretty shop_block" data-animated="fadeIn">';
	
						/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;	

							$wecare_projects_detail_xml = get_post_meta($post->ID, 'wecare_projects_detail_xml', true);

							if($wecare_projects_detail_xml <> ''){

								$campers_post_xml = new DOMDocument ();

								$campers_post_xml->loadXML ( $wecare_projects_detail_xml );

								$projects_duration = wecare_find_xml_value($campers_post_xml->documentElement,'projects_duration');	
							
							}
											
							/* Array For Categories */
							$catArray = array();
							
							/* Project Categories */
							$categories = get_the_terms( $post->ID, 'projects-categories' );
								
							if($categories <> ''){
								foreach ( $categories as $category ) {
									/* Error Check */
									if(is_object($category)){
										$catArray[] =  esc_attr($category->term_id)." ";
									}else{
										$catArray = array();
									}
								}
								
								$cat = implode(' ',$catArray);
							}
							
							$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
							
							$output .= '
							
							<div class="element gall '.$cat.'">
								<div class="frame">'.get_the_post_thumbnail($post->ID, array(282,282)).'</div>
							</div>';

						} /* endwhile */
						
						$output .= '
						</div>';
						if(!empty($readmore_text)){
							$output .= ' <div class="btn-row"><a href="'.esc_url($readmore_url_link).'" class="btn-style-1">'.esc_attr($readmore_text).'</a></div>';
						}
	
					} wp_reset_query(); /* endif have post */
					

					$output .= '
				   </div>
			</section>';
				

			return $output;
				
				

		} /* OutPut Function Ends Here */
		
		
	} /* class ends here */
	
	new wecare_projects_filter;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_projects_filter extends WPBakeryShortCode {
		}
	}
}