<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_facts")){
	class wecare_facts{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_facts_init"));
			add_shortcode('wecare_facts',array($this,'wecare_facts_shortcode'));
		}
		function wecare_facts_init(){

			if(function_exists("vc_map")){
				
				
				vc_map( array(
					"base" => "wecare_facts",
					"name" => __( "Facts ", "js_composer" ),
					"class" => "wecare_facts_class",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"icon" => "wecare_facts",
					"params" => array(
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here i.e ", "js_composer" )
							),
							
							array(
								"type" => "textarea_html",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Facts Shortcodes", "js_composer" ),
								"param_name" => "content",
								"description" => __( "Enter Facts Shortcodes Here i.e [project_facts icon='fa-text-width' count='988' image_url='' text='Content' border_right='add' border_bottom='remove'][/project_facts]", "js_composer" )
							),
							
							
						)
					) 
				);
			}
		}
		
		
		function wecare_facts_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
				
				'element_title' => '',
				

			), $atts );

			extract( $result );
			
			
			$output = '
			
			<section class="fact-figures">
				<div class="element_wrap">
					<div class="row">
					  '.do_shortcode($content).'
					</div>
				</div>
			</section>';
				
			return $output;
			
			wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_facts;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_facts extends WPBakeryShortCode {
		}
	}
}