<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_campaign_slider")){
	class wecare_campaign_slider{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_campaign_slider_init"));
			add_shortcode('wecare_campaign_slider',array($this,'wecare_campaign_slider_shortcode'));
		}
		function wecare_campaign_slider_init(){

			if(function_exists("vc_map")){

				/* Charity Project */
				 $charity_args = array(
					'type'                     => 'campaign',
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'date',
					'order'                    => 'DESC',
					'hide_empty'               => 1,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => 'campaign_category',
					'pad_counts'               => false 
				);
				
				$charity_categories = get_categories( $charity_args ); 				
						
				
				$charity_taxonomies = get_taxonomies();
				
				if($charity_categories){
					$charity_categoryArray[0] = "All";
					foreach($charity_categories as $charity_category_list){
						$charity_categoryArray[$charity_category_list->term_id] = $charity_category_list->name;
					}
				} else {
					$charity_categoryArray = array();
				}
				
	
				vc_map( array(
					"base" => "wecare_campaign_slider",
					"name" => __( "Campaign Slider", "js_composer" ),
					"class" => "wecare_campaign_slider_class",
					"icon" => "wecare_campaign_slider",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(

							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Sub Title", "js_composer" ),
								"param_name" => "element_subtitle",
								"description" => __( "Enter Element Sub Title", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title Here", "js_composer" )
							),
	
							array(
								"type" => "dropdown",
								"holder" => "p",
								"heading" => __( "Category Campaign", "js_composer" ),
								"param_name" => "project_category_name",
								"value" => $charity_categoryArray,
								"description" => __( "Select Campaign Category From The Dropdown", "js_composer" )
							),
							
							array(
								'type' => 'vc_link',
								'heading' => __( 'Learn More (Link)', 'js_composer' ),
								'param_name' => 'readmore_url',
								'description' => __( 'Add Text & Link For Button.', 'js_composer' ),
							),
							
						)
					) 
				);
			}
		}
		
		
		function wecare_campaign_slider_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
			
				'element_subtitle' => '',
				'element_title' => '',
				'readmore_url' => '',
				'project_category_name' => '',
				'bg_image' => '',
				
			), $atts );

			extract( $result );
			

			global $wpdb,$post;

			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			
			if($project_category_name != 'All' && !empty($project_category_name)){
				
				$term = '';
				
				$term = get_term_by('name', $project_category_name, 'campaign_category');
				
				if(is_object($term)){
				
					$category_id = $term->term_id;
					
					$stack_cat_all = array('tax_query' => array(
							array(
								'taxonomy' => 'campaign_category',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						),
					);
					
					$args = array( 
						'post_type' => 'campaign',
						'posts_per_page' => -1,
						'paged' 			=> $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'campaign_category',
								'terms' => $category_id,
								'field' => 'term_id',
							)
						), 
						'post_status'       => 'publish',
						'orderby' 			=> 'date',
						'order' 			=> 'DESC'
					);
					
				}else{
				
					$args = array( 
						'post_type' 		=> 'campaign',
						'post_status'       => 'publish',
						'paged' 			=> $paged,
						'posts_per_page' 	=> -1,
						'orderby'		 	=> 'date',
						'order' 			=> 'DESC'
					);
				
				}
			
			}else{
			
				
				$args = array( 
					'post_type' 		=> 'campaign',
					'post_status'       => 'publish',
					'paged' 			=> $paged,
					'posts_per_page' 	=> -1,
					'orderby'		 	=> 'date',
					'order' 			=> 'DESC'
				);
			
			}
						
						
			query_posts($args);
		
			
			/* Single Image */
			
			$bg_image = wpb_getImageBySize( array( 'attach_id' => $bg_image, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
			
			$bg_image =  $bg_image['p_img_large'][0];
			
			$inline_style = '';
			
			$inline_style = '<style>.welcome-donate-box{ background:#000 url('.esc_url($bg_image).') no-repeat left top/cover}</style>';
			
			/* Build Link First */
			
			$readmore_url = vc_build_link( $readmore_url );

			if(!empty($readmore_url['url'])){ $readmore_url_link =  esc_url($readmore_url['url']); }else{ $readmore_url_link = ''; }

			if(!empty($readmore_url['title'])){ $readmore_text =  esc_attr($readmore_url['title']); }else{ $readmore_text = ''; }			
			
			/* HTML Markup */
				
				$output = $inline_style.'
				
					<section class="causes-section">
					  <div class="element_wrap">
						<div class="heading-style-1"> 
							<span>'.esc_attr($element_subtitle).'</span>
							<h2>'.esc_attr($element_title).'</h2>
						</div>
						<div id="causes-slider" class="owl-carousel">';
	
						/* Loop Begins */
						
						wp_enqueue_script( 'cp-owl', wecare_PATH_URL.'/frontend/js/owl.carousel.min.js', false, '1.0', true);

							wp_enqueue_style('cp-owl',wecare_PATH_URL.'/frontend/css/owl.carousel.css');
						
						if ( have_posts() ) {
						 	while ( have_posts() ) { the_post(); global $post;
							
								/* Get Campaign Object */
								$campaign = charitable_get_current_campaign();
								
								/* Percentage Donated */
								$percentage_donated_raw = intval($campaign->get_percent_donated_raw());
								
								/* Days Left */
								$campaign_days_left = $campaign->get_time_left();
								
								/* Get Donor Count */
								$campaign_donor_count = $campaign->get_donor_count();
								
								/* Get Currency Symbol */
								//$currency_symbol = Charitable_Currency::get_currency_symbol();
								
								/* Initialize Variables */
								$donated_amount = $goal_amount = $needed_amount = '';
								
								/* Campaign Goal */
								$goal_amount = $campaign->sanitize_campaign_goal( $campaign->get( 'goal' ) );
								
								/* Donated Amount */
								$donated_amount = intval($campaign->get_donated_amount());
								
								/* Amount Left */
								$needed_amount = $goal_amount - $donated_amount;
						  
								$output .= '
									
									<div class="item">
										<div class="causes-box">
										  <div class="frame"><a href="'.get_the_permalink().'">'.get_the_post_thumbnail($post->ID, array(265,200)).'</a></div>
										  <div class="text-box">
											<h3><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
											<div class="progress">
												<div class="progress-bar" role="progressbar" aria-valuenow="'.esc_attr($percentage_donated_raw).'" aria-valuemin="0" aria-valuemax="100" style="width: '.esc_attr($percentage_donated_raw).'%;"> 
													<span class="sr-only">'.esc_attr($percentage_donated_raw).'% '.esc_html__('Complete','theneeds').'</span> 
												</div>
											</div>
											<ul class="donors">
											  <li> 
												<span class="title">'.esc_html__('Need','wecare').'</span> 
												<strong class="amount">'.charitable_format_money(intval($goal_amount)).'</strong> 
											  </li>
											  <li> 
												<span class="title">'.esc_html__('Donors','wecare').'</span> 
												<strong class="amount">'.esc_attr($campaign_donor_count).'</strong> 
											  </li>
											  <li> 
												<span class="title">'.esc_html__('Raised','wecare').'</span> 
												<strong class="amount">'.charitable_format_money(intval($donated_amount)).'</strong> 
											  </li>
											</ul>
										  </div>
										  <div class="btm-row">
											<a href="'.get_the_permalink().'" class="btn-now"><i class="fa fa-calendar" aria-hidden="true"></i>'.$campaign_days_left.'</a>
											<a href="'.esc_url(charitable_get_permalink( 'campaign_donation_page', array( 'campaign' => $campaign ) )).'" class="btn-now btn-color">'.esc_html__('Contribute Now','theneeds').'</a>
										  </div>
										</div>
									</div>';
		 
						  
							} /* endwhile */ wp_reset_query();
						} /* endif */
						
						$output .= '  
						</div>
						<div class="btn-row"><a href="'.esc_url($readmore_url_link).'" class="btn-style-2">'.$readmore_text.'</a></div>
					  </div>
					</section>';

			return $output;

			wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_campaign_slider;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_campaign_slider extends WPBakeryShortCode {
		}
	}
}