<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_contact_map")){
	class wecare_contact_map{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_contact_map_init"));
			add_shortcode('wecare_contact_map',array($this,'wecare_contact_map_shortcode'));
		}
		function wecare_contact_map_init(){

			if(function_exists("vc_map")){
				
				
				vc_map( array(
					"base" => "wecare_contact_map",
					"name" => __( "Map + Contact", "js_composer" ),
					"class" => "wecare_contact_map_class",
					"icon" => "wecare_contact_map_icon",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Form Title Here", "js_composer" )
							),
							
							array(
								"type" => "textarea",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Description", "js_composer" ),
								"param_name" => "description_html",
								"description" => __( "Enter Description For Contact Details Here", "js_composer" )
							),
							
							array(
								"type" => "textarea_html",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Contact Form 7 Shortcode", "js_composer" ),
								"param_name" => "content",
								"description" => __( "Add Contact Form 7 Shortcode Here", "js_composer" )
							),
		
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Address", "js_composer" ),
								"param_name" => "address",
								"description" => __( "Enter Contact Address Here", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Phone", "js_composer" ),
								"param_name" => "phone",
								"description" => __( "Enter Contact Phone Here", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Skype", "js_composer" ),
								"param_name" => "fax",
								"description" => __( "Enter Contact Skype Here", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Web", "js_composer" ),
								"param_name" => "web",
								"description" => __( "Enter Web Address Here", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Add Email Address", "js_composer" ),
								"param_name" => "email",
								"description" => __( "Enter Email Address Here", "js_composer" )
							),
							
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Enter Map Location Latitude", "js_composer" ),
								"param_name" => "location_lat",
								"description" => __( "Enter Location Latitude Here i.e 48.85661", "js_composer" )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Enter Map Location Logitude", "js_composer" ),
								"param_name" => "location_long",
								"description" => __( "Enter Location Logitude Here i.e 2.35222", "js_composer" )
							),		
				
						)
					) 
				);
			}
		}
		
		
		function wecare_contact_map_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
				
				'element_title' => '',
				'address' => '',
				'phone' => '',
				'fax' => '',
				'email' => '',
				'web' => '',
				'location_lat' => '',
				'location_long' => '',
				'description_html' => '',
				
			), $atts );

			extract( $result );
			
		
			if(!empty($location_lat)){ $location_lat =  esc_attr($location_lat); }else{ $location_lat = ''; }
			
			if(!empty($location_long)){ $location_long =  esc_attr($location_long); }else{ $location_long = ''; }
			
			$output = '';
			
			if(function_exists('wecare_get_themeoption_value')){
				
				$wecare_google_api_key = '';
			
				$wecare_google_api_key = wecare_get_themeoption_value('google_map_api','general_settings'); 
			
				if(!empty($wecare_google_api_key)){ ?>

					<script src="http://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr($wecare_google_api_key); ?>"></script>
					<script>
						jQuery(document).ready(function($) {
							"use strict";
							if ($('#map_contact_1').length) {
								var map;
								var myLatLng = new google.maps.LatLng(<?php echo esc_attr($location_lat);?>, <?php echo esc_attr($location_long);?>);
								//Initialize MAP
								 var myOptions = {
									zoom: 11,
									center: myLatLng,
									//disableDefaultUI: true,
									zoomControl: true,
									mapTypeId: google.maps.MapTypeId.ROADMAP,
									mapTypeControl: false,
									scrollwheel: false,
									styles: [{
										stylers: [{
											hue: '#cacaca'
										}, {
											saturation: -100,
										}, {
											lightness: 10
										}]
									}],
								}
								map = new google.maps.Map(document.getElementById('map_contact_1'), myOptions);
								//End Initialize MAP
								//Set Marker
								var marker = new google.maps.Marker({
									// zoom: 7,
									position: map.getCenter(),
									map: map,
									
								});
								marker.getPosition();
								//End marker
							}
						});
					</script>
					<?php
				}
			}

					$output = '
					
					<section class="contact-section">
					  <div class="container">
						<div class="contact-top-section">
						  <div class="row">
							<div class="col-md-5">
							  <div class="address-box-1">
								<h2>'.$element_title.'</h2>
								<p>'.$description_html.'</p>
								<ul>
								  <li> <i class="fa fa-paper-plane" aria-hidden="true"></i>
									<div class="text-col">
									  <p>'.$address.'</p>
									</div>
								  </li>
								  <li> <i class="fa fa-envelope" aria-hidden="true"></i>
									<div class="text-col"> 
										<a href="mailto:'.is_email($email).'">'.is_email($email).'</a> 
										<a href="'.esc_url($web).'">'.esc_url($web).'</a> 
									</div>
								  </li>
								  <li>
									<div class="text-col"> 
										<i class="fa fa-phone" aria-hidden="true"></i> 
										<a>'.$phone.' </a> 
										<a>'.$fax.'</a> 
									</div>
								  </li>
								</ul>
							  </div>
							</div>
							<div class="col-md-7">
							  '.do_shortcode($content).'
							</div>
						  </div>
						</div>
					  </div>';
						/* If Not Empty Map Lat Long API KEY */
						if(!empty($wecare_google_api_key) && !empty($location_lat) && !empty($location_long)){
						
							$output .= ' 
							  
							<div class="map-1">
								<div id="map_contact_1" class="map_canvas active"></div>
							</div>';
							
						}else{
						
							$output .= '
							
							<div class="contact-map">
								<div class="map_canvas">
									<h3>'.esc_html__('Please Enter Correct Map Details i.e API Key, Latitude, Longitude','wecare').'</h3>
								</div>
							</div>';
						}
						
						$output .= ' 
					</section>';
	
			return $output;

		} /* end of function */
		
		
	}
	
	new wecare_contact_map;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_contact_map extends WPBakeryShortCode {
		}
	}
}