<?php
/*
* Add-on Name: CP Addons For Visual Composer
* Add-on URI: http://dev.crunchpress.com
*/
if(!class_exists("wecare_about")){
	class wecare_about{
		static $add_plugin_script;
		function __construct(){
			add_action("init",array($this,"wecare_about_init"));
			add_shortcode('wecare_about',array($this,'wecare_about_shortcode'));
		}
		function wecare_about_init(){

			if(function_exists("vc_map")){
	
				vc_map( array(
					"base" => "wecare_about",
					"name" => __( "About Section", "js_composer" ),
					"class" => "wecare_about_class",
					"icon" => "wecare_about",
					"category" => __( 'CrunchPress', 'js_composer' ),
					"params" => array(
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Caption", "js_composer" ),
								"param_name" => "element_caption",
								"description" => __( "Enter Element Caption", "js_composer" )
							),
					
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Element Title", "js_composer" ),
								"param_name" => "element_title",
								"description" => __( "Enter Element Title", "js_composer" )
							),
							

							array(
								'type' => 'textarea_html',
								'heading' => __( 'Description', 'js_composer' ),
								'param_name' => 'content',
								'description' => __( 'Add Description For Element.', 'js_composer' ),
							),
	
							array(
								'type' => 'attach_image',
								"holder" => "p",
								'heading' => __( 'Images', 'js_composer' ),
								'param_name' => 'bg_image',
								'value' => '',
								'description' => __( 'Select Images From Media Library', 'js_composer' )
							),
							
							array(
								"type" => "textfield",
								"holder" => "p",
								"class" => "",
								"heading" => __( "Video URL", "js_composer" ),
								"param_name" => "video_url",
								"description" => __( "Enter Video URL Here i.e https://player.vimeo.com/video/125437772", "js_composer" )
							),

						)
					) 
				);
			}
		}
		
		
		function wecare_about_shortcode( $atts, $content = null ) {
		
			$result = shortcode_atts( array(
				
				'element_caption' => '',
				'element_title' => '',
				'video_url' => '',
				'bg_image' => '',
				
			), $atts );

			extract( $result );
			
			/* Background Image */
				
			$bg_image = wpb_getImageBySize( array( 'attach_id' => $bg_image, 'thumb_size' => '100', 'class' => 'vc_single_image-img' ) );
			
			$bg_image =  $bg_image['p_img_large'][0];
			
			if(!empty($bg_image)){
			
				$inline_style = '<style> .about-section .video-box{ background: #000 url('.esc_url($bg_image).') no-repeat left top/100% }</style>';
			
			}else{
				
				$inline_style = '';
			}

			$output = $inline_style.'
				<section class="about-section">
				<section class="about-section-1">
					<div class="element_wrap">
					  <div class="row">
						<div class="col-md-6 col-sm-6">
						  <div class="text-box">
							<div class="heading-style-1"> 
								<span>'.$element_caption.'</span>
								<h2>'.$element_title.'</h2>
							</div>
							'.wpautop($content).'
						  </div>
						</div>
						<div class="col-md-6 col-sm-6">
						  <div class="video-box"> <a href="#" class="play-icon" data-toggle="modal" data-target="#myModal"></a> 
							<!-- Modal -->
							<div class="modal fade" id="myModal" tabindex="-1" role="dialog">
							  <div class="modal-dialog" role="document">
								<div class="modal-content">
								  <div class="modal-header">
									<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
								  </div>
								  <div class="modal-body">
									<iframe src="'.$video_url.'"></iframe>
								  </div>
								</div>
							  </div>
							</div>
						  </div>
						</div>
					  </div>
					</div>
				  </section>
				</section>';
			
			return $output;

			wp_reset_postdata();

		} /* end of function */
		
		
	}
	
	new wecare_about;
	
	if(class_exists('WPBakeryShortCode'))
	{
		class WPBakeryShortCode_wecare_about extends WPBakeryShortCode {
		}
	}
}